
function [Yproj_is, Yproj_os_mean, trend_os_only] = fcst_y_trend_mean(Y,q_is,h_os,I_1,I_trend)
    % Process the Y data .. where Y is T x n
    % q_is ... number of cosine transformations for in-sample period
    % h_os ... number of out-of-sample periods
    % n_draws ... number of draws for the out-of-sample period
    % I_1 ... is a indicator for the I(1) model, otherwise it is the I(0) model
    % I_trend ... 0 if include mean (level), 1 if include level and linear trend

    % Some constants
    T_is = size(Y,1);
    n = size(Y,2);
    T_os = T_is + h_os;             % Full sample period
    q_os = ceil((T_os/T_is)*q_is);  % Full sample value of q

    % Step 1: % Compute the long-run covariance matrix for Y(I0) or dY(I1)
    X = Y;
    if I_1 == 1
        X = dif(Y,1);
        X = X(2:end,:);
    end
    nma = 2;
    ikern = 1;
    Y_cov_lr = lr_cov(X,nma,ikern);

    % Step 2: Construct the in-sample matrix of weights
    WT_is = [ones(T_is,1)];
    q1_is = q_is;
    if I_trend == 1
        trend_is = (1:1:T_is)';
        WT_is = [WT_is trend_is];
        q1_is = q_is - 1;
    end
    % Compute periodic terms -- eigenvectors of detrended covariance matrix
    cov_rw_is = rw_cov(T_is);
    M = eye(T_is) - WT_is*inv(WT_is'*WT_is)*WT_is';
    cov_dt_is = M*cov_rw_is*M';
    [evec_mat,eval]=eig(cov_dt_is,'vector');
    A = evec_mat(:,1:q1_is);
    W_is = [WT_is A];
    WP_is = inv(W_is'*W_is)*W_is';
    B_is = WP_is*Y;
    BT_is = WT_is\Y;    % Constant (and trend for I(1) model) in-sample estimate
    % Pad WP_is out with zeros
    WP_is = [WP_is zeros(size(WP_is,1),T_os-T_is)];


    % Step 3: Construct the full-sample matrix of weights
    WT_os = [ones(T_os,1)];
    q1_os = q_os;
    if I_trend == 1
        trend_os = (1:1:T_os)';
        WT_os = [WT_os trend_os];
        q1_os = q_os - 1;
    end
    % Compute periodic terms -- eigenvectors of detrended covariance matrix
    cov_rw_os = rw_cov(T_os);
    M = eye(T_os) - WT_os*inv(WT_os'*WT_os)*WT_os';
    cov_dt_os = M*cov_rw_os*M';
    [evec_mat,eval]=eig(cov_dt_os,'vector');
    A = evec_mat(:,1:q1_os);
    W_os = [WT_os A];
    WP_os = inv(W_os'*W_os)*W_os';

    % Step 4: Compute the in-sample/full-sample covariance matrix 
    var_mu = (1.0e+06);                % diffuse prior for constant and trend
    cov_var_mu = var_mu*WT_os*WT_os';  % Component of covariance matrix for unknown mean (and trend) 
    if I_1 == 1
        cov_error = rw_cov(T_os);
    elseif I_1 == 0
        cov_error = eye(T_os);
    end
    cov_fs = cov_var_mu + cov_error;

    % Get joint normal covariance matrix pieces
    S11 = WP_is*cov_fs*WP_is';
    S21 = WP_os*cov_fs*WP_is';
    S22 = WP_os*cov_fs*WP_os';
    G = S21*inv(S11);
    V2_1 = S22 - G*S21';
    V2_1 = 0.5*(V2_1 + V2_1'); % Ensure symmetry
    B_os_mean = G*B_is;
    
    % % Step 6: Get Draws of B_os
    % [chol_Y_cov_lr] = sqrt_psd(Y_cov_lr);
    % [chol_V2_1] = sqrt_psd(V2_1);
    % cholV = kron(chol_Y_cov_lr,chol_V2_1); % Cholesky factor (lower triangular) for the covariance matrix of vec(B_os)|B_is
    % vecB_draws = repmat(B_os_mean(:),1,n_draws) + cholV*randn(length(B_os_mean(:)),n_draws);

    % Get In-sample estimate of Low-freq component of Y
    Yproj_is = W_is*B_is;
    Yproj_is = [Yproj_is; NaN(T_os-T_is,size(Yproj_is,2))];

    % Get LF Mean
    Yproj_os_mean = W_os*B_os_mean;

    % % Get OOS Draws of Low-freq component of Y
    % Yproj_os_draws = NaN(T_os,size(Y,2),n_draws);
    % for i = 1:n_draws
    %     B_os = reshape(vecB_draws(:,i),size(B_os_mean));
    %     Yproj_os_draws(:,:,i) = W_os*B_os;
    % end

    % Get constant (and trend for I(1) model) estimates
    trend_os_only = WT_os*BT_is;
    
end
    